	% Example 12.15
	clear all
	close all
	clc
	% Requirements for the digital lowpass filter
	wcT = 0.2*pi;	wsT = 0.45*pi;	Amax = 0.1; Amin = 60;
	Wac = tan(wcT/2); Was = tan(wsT/2);
	N = CA_ORDER_S(Wac, Was, Amax, Amin)	
	%	Initial
	WcT = 0.22*pi;	WsT = 0.428*pi;	Amax = 0.09; Amin = 64;	
	% Requirements for the analog prototype lowpass filter
	Wac = tan(wcT/2); Was = tan(wsT/2);
	% Design of the analog prototype lowpass filter
	N = CA_ORDER_S(Wac, Was, Amax, Amin);
	N = 5;					% We select a 3th-order filter
	[G, Z, R_ZEROS, P, Wsnew] = CA_POLES_S(Wac, Was, Amax, Amin, N);
	Rs = 1; RL = 1; Ladder = 0; % 1 for a T ladder and 0 for a  ladder	
	[L, C, Rs, RL, W0, K] = CA_LADDER(G, Z, R_ZEROS, P, Wac, Was, Amax, Amin, Rs, RL, Ladder, 'a');
	
	GC = C; Gl = 1./L; Rs = 1; RL = 1;	
	%==================== From the source side =====================
	% Adaptor I - PARALLEL
	G8 = 1/Rs + GC(1); 					
	alfa(1) = 2/Rs/(1/Rs + GC(1) + G8);
	% Adaptor II - PARALLEL
	G9 = Gl(2) + GC(2);		 	
	alfa(3) = 2*Gl(2)/(Gl(2) + GC(2) + G9);
	% Adaptor III - SERIES 
	R8 = 1/G8; R9 = 1/G9; R10 = R8 + R9;
	alfa(2) = 2*R8/(R8 + R9 + R10);	
	%===================== From the load side ===================
	% Adaptor V - PARALLEL
	G12 = Gl(4) + GC(4);					
	alfa(7) = 2*Gl(4)/(G12 + Gl(4) + GC(4));
	% Adaptor VII - PARALLEL
	G13 = 1/RL+ GC(5);						
	alfa(8) = 2/RL/(1/RL + GC(5) + G13);	
	% Adaptor VI - SERIES 
	R13 = 1/G13; R12 = 1/G12; R11 = R12 + R13;
	alfa(6) = 2*R13/(R11 + R12 + R13);
	% Adaptor IV - PARALLEL
	G10 = 1/R10; 	G11 = 1/R11;			
	alfa(4) = 2*G10/(G10 + GC(3) + G11);
	alfa(5) = 2*G11/(G10 + GC(3) + G11);
	
	%===========
	wT = linspace(0, pi, 1000);
	alfa(1) = 33/128; alfa(2) = 3/32; alfa(3) = 5/8; alfa(4) = 1/8;
	alfa(5) = 3/16;  alfa(6) = 5/32; alfa(7) = 53/128; alfa(8) = 33/128;
	
	c1 = 2; c2 = 1/4; c3 = 4; c4 = 1/2; c5 = 4; c6 = 1/2;
	
	a1 = alfa(1); a2 = alfa(2);a3 = alfa(3);a4 = alfa(4);a5 = alfa(5);
	a6 = alfa(6);a7 = alfa(7); a8 = alfa(8);
	
	G11 = a1*(2+a2*(a4-2))*c1;
	G12 = 1-2*a1-a2*(a3-a1)*(2-a4);
	G13 = a2*a3*(2-a4)/c2;
	G14 = a2*(a3*(a4-2)+a5*a7)/(c2*c3);
	G15 = -a2*a5*a7/(c2*c3*c4);
	G16 = a2*a5*(a7-a8)/(c2*c3*c4*c5);
	G21 = a1*(a4-2)*(1-a2)*c1*c2;
	G22 = (a1+a3-2+(a3-a1)*(a4*(1-a2)-1+2*a2))*c2;
	G23 = 1-a2*a3*(2-a4)-a3*a4;
	G24 = ((1-a2)*(a3*a4+a5*a7)+2*(a2*a3-1))/c3;
	G25 = a5*a7*(a2-1)/(c3*c4);
	G26 = a5*(a7-a8)*(1-a2)/(c3*c4*c5);
	G31 = -a1*a4*c1*c2*c3;
	G32 = -a4*(a3-a1)*c2*c3;
	G33 = a3*a4*c3;
	G34 = 1-a3*a4-a5*a7;
	G35 = a5*a7/c4;
	G36 = -a5*(a7-a8)/(c4*c5);
	G41 = a1*a4*(1-a6)*c1*c2*c3*c4;
	G42 = a4*(a3-a1)*(1-a6)*c2*c3*c4;
	G43 = a3*a4*(a6-1)*c3*c4;
	G44 = (a3*a4*(1-a6)-2+a7*(a5*(1-a6)+2*a6))*c4;
	G45 = 1+a7*(a6*(a5-2)-a5);
	G46 = ((a7-a8)*(a5-1+a6*(2-a5))+a7+a8-2)/c5;
	G51 = a1*a4*a6*c1*c2*c3*c4*c5;
	G52 = a4*a6*(a3-a1)*c2*c3*c4*c5;
	G53 = -a3*a4*a6*c3*c4*c5;
	G54 = a6*(a3*a4+a7*(a5-2))*c4*c5;
	G55 = a6*a7*(2-a5)*c5;
	G56 = 1-2*a8-a6*(a7-a8)*(2-a5);
	G61 = a1*a4*a6*c1*c2*c3*c4*c5*c6;
	G62 = a4*a6*(a3-a1)*c2*c3*c4*c5*c6;
	G63 = -a3*a4*a6*c3*c4*c5*c6;
	G64 = a6*(a3*a4+a7*(a5-2))*c4*c5*c6;
	G65 = a6*a7*(2-a5)*c5*c6;
	G66 = (2*(1-a8)-a6*(a7-a8)*(2-a5))*c6;
	
	G = [G11, G12, G13, G14, G15, G16;...
	G21, G22, G23, G24, G25, G26;...
	G31, G32, G33, G34, G35, G36;...
	G41, G42, G43, G44, G45, G46;...
	G51, G52, G53, G54, G55, G56;...
	G61, G62, G63, G64, G65, G66];
	%====	
	D = [G61];
	C = [G62, G63, G64, G65, G66];
	B = [G11, G21, G31, G41, G51]';
	A = [G12, G13, G14, G15, G16;...
	G22, G23, G24, G25, G26;...
	G32, G33, G34, G35, G36;...
	G42, G43, G44, G45, G46;...
	G52, G53, G54, G55, G56];	
	
	if 1 == 2
		% scaling
		K = zeros(5,5);
		for n = 1:100
			K = K + (A^n*B)*(A^n*B)';
		end		
		K = K+ B*B'	% Make diagonal elements  1
		x = 1; v = zeros(5,1);ytwo=0;yh=0;
		for n = 1:100
			y = C*v + D*x;
			v = A*v + B*x;
			x = 0;
			ytwo = ytwo +v*v';
			yh=yh+y^2;
		end
		ytwo
		yh
		stop
	end 
	x = 1; v = zeros(5,1);
	for n = 1:11
		h(n) = C*v + D*x;
		v = A*v + B*x;
		x = 0;
	end
	%	figure(4)
	%	PLOT_IMPULSE_RESPONSE_Z(h)				
	%	figure(5)
	[G0, Z, P] = IMPULSE_2_P_Z(h, 5);	
	Att = PZ_2_ATT_Z(G0, Z, P, wT); 	
	Att = Att-min(Att);
	subplot('position', [0.08 0.4 0.88 0.5]);	
	PLOT_ATT_Z(wT, Att, pi, 80)
	%	axis([0 pi 0 80]);zoom on			
	
end
end
subplot('position', [0.08 0.4 0.88 0.5]);	
PLOT_ATT_Z(wT, Att, pi, 80)
axis([0 pi 0 80]);zoom on
%	figure(6)
%	PLOT_PZ_Z(Z, P)

